﻿// 
//  Suite la restructuration ( DE14408 ) de voxco.agent pour les differentes commandes , mask telephonique, et la methode
//  getMessage pour la verication des messages en attentes pour l'agent , nous avons cree un effet de 
//  bord indesirable. Apres 20 minutes d'inactivite , la session de voxco.agent expirait ( sessioon timeout )
//  Les consequences:
//
//  Les boutons: Project , Close , Help et preference devenait inutilisable.
//
//  Avec les anciennes version de voxco.agent , la methode getMessage permettait de garder la session
//  vivante puisqu'elle passait par voxco.agent pour terminer dans voxco.agent.webservice.
//
//  Pour des raisons d'efficacite et des problemes relie a HTTPS (DE15560 ), la commande getMessage est envoyee
//  directement a voxco.agent.webservice. Comme elle ne passe plus par voxco.agent , nous avons
//  perdu l'activite constante sur le service voxco.agent puisque la commande getMessage etait 
//  envoye a toute le X secondes.
//  
//  PingSession permet de garder une activitee constante sur voxco.agent afin de garder la 
//  sa session vivante pour durée complete du travaille de l'agent sur le plancher ( DE16323 )
//
//

var PingSession = {

    //
    //  m_iInterval : intervalle du ping en milli-seconde
    //  m_iTimerId  : id du timer
    //  m_Ajax      : Objet ajax interne pour l'envoie des requete
    //  m_Url       : Url
    //  m_Medhod    : la Mehode 
    //


    m_iInterval: 300000,
    m_iTimerId: 0,
    m_Ajax: null,
    m_Url:"" ,
    m_Method:"Ping" ,

    Ping: function (ajax, url) {

        this.m_Url = url;
        this.m_Ajax = ajax;

        if( this.m_iTimerId == 0 ){
            this.m_iTimerId = setInterval(this.Send, this.m_iInterval);
        }
     },

    Send: function()
    {
        PingSession.m_Ajax.callServerMethod(PingSession.m_Url,PingSession.m_Method, null, PingSession._success, PingSession._error, null);
    },
    
    stop: function () {

        if (this.m_iTimerId != 0) {
            clearInterval(this.m_iTimerId);
            this.m_iTimerId = 0;
        }
    },

    _error: function (xhr, msg, e) {

        if (typeof ConsoleDebug == "object") {
            ConsoleDebug._error("Ping> ping session sent successfully...");
        }
    },

    _success: function( result) {
        if (typeof ConsoleDebug == "object") {
            ConsoleDebug._info("Ping> ping session sent successfully...");
        }
    }

};




var PingIntWeb = {

   m_pingDelay: 30000,
   m_url:  null,
   m_PingId: 0,


    CreateTimer: function (baseurl) {

        if (this.m_url != null) {
            // Timer already created ;
            return;
        }

        var ProjectAssignment = gClassManager.getAgentAssignmentClass();
        var sessionguid = ProjectAssignment.getSessionGuid();
        var _url = baseurl + '?imode=3&IACTION=28&sessionguid=' + sessionguid;

        if (_url != undefined && _url != null) {
            this.m_url = _url;
        }

        this.Set();
        return;
    },

    Set: function () {

        var ping = this.getPingDelay();
        if (ping != undefined && ping != this.m_pingDelay) {
            this.clear();
            this.m_pingDelay = ping;
            this.m_PingId = setTimeout(this.execute, this.m_pingDelay);
            return;
        }

        if (this.m_PingId == 0) {
            this.m_PingId = setTimeout(this.execute, this.m_pingDelay);
        }

        return this.m_pingDelay;
    },

    getPingDelay: function () {

        if (_hiddens == null) {
            return;
        }

        var delay = _hiddens.getItem('PINGDELAY');
        if (delay != undefined) {
            if (false === isNaN(delay)) {
                delay = Number(delay) * 1000; // already divided by 2
            }
        }

        return delay;
    },

    clear:function () {

        if (this.m_PingId != 0 && this.m_PingId != undefined) {
            clearTimeout(this.m_PingId);
            this.m_PingId = 0;
        }

        return;
    },

    execute: function () {

        if (PingIntWeb.m_url == null) {
            PingIntWeb._debug("Might be a a blend project with no associated outbound module. Intweb url ping is unknown");
            return;
        }

        var closeSentinel = gClassManager.getCloseSentinelFrame();
        var ping = gClassManager.getPingFrame();
        if (ping != undefined && closeSentinel != undefined) {
            if (closeSentinel._status > closeSentinel._STATUS_NOTSIGNEDON) {
                PingIntWeb._info("Sending ping to intweb at location: " + PingIntWeb.m_url);
                ping.location = PingIntWeb.m_url;
            }
        }

        PingIntWeb.m_PingId = setTimeout(PingIntWeb.execute, PingIntWeb.m_pingDelay);
        return;
    },

    _debug: function (message) {
        try {
            ConsoleDebug._debug(message);
        }
        catch (e) {
        }
    },

    _info: function (message) {
        try{
            ConsoleDebug._info(message);
        }
        catch( e ){
        }
    }
}
